#include <iostream>
#include <string>
#include <queue>
#include <algorithm>

using namespace std;

typedef long long int Z;

Z n, m;

struct Edge {
	Z dest;
	Z cost;
	Z ind;
};

vector<vector<Edge>> G;

vector<Z> dist(Z s) {
	priority_queue<pair<Z, Z>> Q;
	Q.emplace(0, s);
	
	vector<Z> ret(n, -1);
	while(!Q.empty()) {
		auto p = Q.top();
		Q.pop();
		Z d = -p.first;
		Z v = p.second;
		if(ret[v] != -1) continue;
		ret[v] = d;
		for(auto e : G[v]) {
			Q.emplace(-d - e.cost, e.dest);
		}
	}
	
	return ret;
}

bool visited[20005];
vector<Z> order;
void dfs(Z v) {
	if(visited[v]) return;
	for(auto e : G[v]) {
		dfs(e.dest);
	}
	visited[v] = true;
	order.push_back(v);
}

int main() {
	cin.sync_with_stdio(false);
	cin >> n >> m;
	G.resize(n);
	
	Z s = 0;
	Z t = n - 1;
	
	for(Z i = 0; i < m; ++i) {
		Z a, b, c;
		cin >> a >> b >> c;
		--a;
		--b;
		G[a].push_back(Edge{b, c, i + 1});
		G[b].push_back(Edge{a, c, i + 1});
	}
	
	vector<Z> dists = dist(s);
	vector<Z> distt = dist(t);
	Z d = dists[t];
	
	for(Z v = 0; v < n; ++v) {
		if(dists[v] == -1) continue;
		vector<Edge> uus;
		for(auto e : G[v]) {
			if(d == dists[v] + e.cost + distt[e.dest]) {
				uus.push_back(e);
			}
		}
		swap(G[v], uus);
	}
	
	dfs(s);
	reverse(order.begin(), order.end());
	
	vector<Z> ends(n, 0);
	Z cnt = 0;
	vector<Z> imp;
	for(Z v : order) {
		cnt -= ends[v];
		
		if(cnt == 0 && G[v].size() == 1) {
			imp.push_back(G[v][0].ind);
		}
		
		for(auto e : G[v]) {
			++cnt;
			++ends[e.dest];
		}
	}
	
	sort(imp.begin(), imp.end());
	
	cout << imp.size() << "\n";
	for(Z i = 0; i < imp.size(); ++i) {
		if(i != 0) cout << " ";
		cout << imp[i];
	}
	cout << "\n";
	
	return 0;
}
